//  Listing 8.12. Przykad skuteczniejszej hermetyzacji

#include <iostream> // lepszy podzia wiedzy
#include <cstring>
using namespace std;

bool isLeft (char c)
{ 
  return (c=='(' || c=='['); 	// czy to lewy nawias?
} 

bool isRight (char c)
{ 
  return (c==')' || c==']'); 	// czy to prawy nawias?
} 

bool symbolsMatch (char c, char sym)
{ 
  return (sym=='('&&c==')')||(sym=='['&&c==']'); 	// czy nawiasy pasuj?
}

bool checkParen (char buffer[]) 			// wyraamy poprzez parametr
{ 
  char store[81]; 	// lokalna tablica
  char c,sym; 
  int i, idx; 
  bool valid;
  i = 0; 
  idx = 0; 
  valid = true; 			// inicjujemy dane
  while (buffer[i] != '\0' && valid) 	// koniec danych czy bd?
  { 
   c = buffer[i]; 			// pobierz nastpny znak
   if (isLeft(c)) 			// czy to lewy nawias?
    { store[idx] = c; idx++; } 		// jeli tak - zapamitaj ten nawias
   else if (isRight(c)) 		// czy to prawy nawias?
   if (idx > 0) 			// czy mamy oczekujcy lewy nawias?
   { 
    sym = store[--idx]; 			// pobierz ostatni oczekujcy lewy nawias
    if (!symbolsMatch(c,sym)) 		// jeli nawiasy nie pasuj do siebie,
    valid = false; 			// to znaczy, e wyraenie jest bdne
   } 
   else
   valid = false; 	// jeli nie ma oczekujcego lewego nawiasu - bd
   i++; } 		// przejd do nastpnego znaku
  if (idx > 0) valid = false; 		// niepasujcy lewy nawias
  return valid;  	// zwr wynik poszukiwania bdu
} 	

void checkParenTest(char expression[])
{ 
  cout << "Wyraenie " << expression << endl; 	// drukuj wyraenie
  if (checkParen(expression)) 			// sprawd poprawno wyraenia
  cout << "jest prawidowe\n"; 			// wydrukuj wynik walidacji - OK
  else
  cout << "jest nieprawidowe\n";   		// wydrukuj wynik walidacji - bd
}

int main()
{
  checkParenTest("a=(x[i]+5)*y;"); 		// pierwszy test - OK
  checkParenTest("a=(x[i)+5]*y;"); 		// drugi test - bd
  checkParenTest("a=(x(i]+5]*y;"); 		// trzeci test - bd
  return 0;
}
